CREATE OR REPLACE VIEW wikalatview AS
SELECT wik_details.* , categories.* FROM wik_details
INNER JOIN categories ON categories.cat_id = wik_details.wik_cat_id

-- view of header
CREATE OR REPLACE VIEW headerview AS
SELECT wik_details.* FROM wik_details
WHERE header = '1'

-- favorite
SELECT wikalatview.* , 1 as favorite FROM wikalatview
INNER JOIN favorite ON favorite.fav_wik_id = wikalatview.wik_id AND favorite.fav_userid = 1
UNION ALL
SELECT * , 0 as favorite FROM wikalatview
WHERE wik_id NOT IN (SELECT wikalatview.wik_id FROM wikalatview
INNER JOIN favorite ON favorite.fav_wik_id = wikalatview.wik_id AND favorite.fav_userid = 1)

-- get favorite
SELECT favorite.* , wik_details.* , users.user_id FROM favorite
INNER JOIN users ON users.user_id = favorite.fav_userid
INNER JOIN wik_details ON wik_details.wik_id = favorite.fav_wik_id

CREATE OR REPLACE VIEW favoriteview AS
SELECT favorite.* , wik_details.* , users.user_id FROM favorite
INNER JOIN users ON users.user_id = favorite.fav_userid
INNER JOIN wik_details ON wik_details.wik_id = favorite.fav_wik_id